/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.charta.block;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import dev.lucaargolo.charta.blockentity.CardTableBlockEntity;
import dev.lucaargolo.charta.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.charta.game.CardDeck;
import dev.lucaargolo.charta.game.CardGame;
import dev.lucaargolo.charta.item.CardDeckItem;
import dev.lucaargolo.charta.item.ModDataComponentTypes;
import dev.lucaargolo.charta.mixed.LivingEntityMixed;
import dev.lucaargolo.charta.network.TableScreenPayload;
import dev.lucaargolo.charta.utils.DyeColorHelper;
import dev.lucaargolo.charta.utils.VoxelShapeUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5815;
import net.minecraft.class_8710;
import net.minecraft.class_9380;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2f;
import org.joml.Vector2i;

public class CardTableBlock
extends class_2237 {
    public static final MapCodec<CardTableBlock> CODEC = CardTableBlock.method_54094(CardTableBlock::new);
    private static final class_265 CENTER = class_2248.method_9541((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    private static final class_265 FEET_NORTH_EAST = class_2248.method_9541((double)10.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)6.0);
    private static final class_265 FEET_SOUTH_EAST = VoxelShapeUtils.rotate(FEET_NORTH_EAST, class_2350.field_11034);
    private static final class_265 FEET_SOUTH_WEST = VoxelShapeUtils.rotate(FEET_NORTH_EAST, class_2350.field_11035);
    private static final class_265 FEET_NORTH_WEST = VoxelShapeUtils.rotate(FEET_NORTH_EAST, class_2350.field_11039);
    private static final class_265 CORNER_NORTH_WEST = Stream.of(class_2248.method_9541((double)0.0, (double)13.0, (double)0.0, (double)6.0, (double)15.0, (double)6.0), class_2248.method_9541((double)0.0, (double)13.0, (double)6.0, (double)6.0, (double)15.0, (double)16.0), class_2248.method_9541((double)6.0, (double)13.0, (double)0.0, (double)16.0, (double)15.0, (double)6.0)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 CORNER_NORTH_EAST = VoxelShapeUtils.rotate(CORNER_NORTH_WEST, class_2350.field_11034);
    private static final class_265 CORNER_SOUTH_EAST = VoxelShapeUtils.rotate(CORNER_NORTH_WEST, class_2350.field_11035);
    private static final class_265 CORNER_SOUTH_WEST = VoxelShapeUtils.rotate(CORNER_NORTH_WEST, class_2350.field_11039);
    private static final class_265 SIDE_WEST = class_2248.method_9541((double)0.0, (double)13.0, (double)0.0, (double)6.0, (double)15.0, (double)16.0);
    private static final class_265 SIDE_NORTH = VoxelShapeUtils.rotate(SIDE_WEST, class_2350.field_11034);
    private static final class_265 SIDE_EAST = VoxelShapeUtils.rotate(SIDE_WEST, class_2350.field_11035);
    private static final class_265 SIDE_SOUTH = VoxelShapeUtils.rotate(SIDE_WEST, class_2350.field_11039);
    private static final Map<Combination, class_265> SHAPES = new HashMap<Combination, class_265>();
    private static final List<Vector2i> VALID_DIMENSIONS = List.of(new Vector2i(3, 3), new Vector2i(4, 3), new Vector2i(5, 3));
    private static final int MAX_SIZE;
    public static final class_2746 VALID;
    public static final class_2746 NORTH;
    public static final class_2746 EAST;
    public static final class_2746 SOUTH;
    public static final class_2746 WEST;
    public static final class_2746 CLOTH;
    public static final class_2754<class_1767> COLOR;

    public CardTableBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)VALID, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CLOTH, (Comparable)Boolean.valueOf(false))).method_11657(COLOR, (Comparable)class_1767.field_7952));
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> blockEntityType) {
        return !level.field_9236 ? CardTableBlock.method_31618(blockEntityType, ModBlockEntityTypes.CARD_TABLE, CardTableBlockEntity::serverTick) : null;
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new CardTableBlockEntity(pos, state);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{VALID, NORTH, EAST, SOUTH, WEST, CLOTH, COLOR});
    }

    @NotNull
    protected class_1269 method_55766(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_3965 hitResult) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (serverPlayer.method_5715()) {
                if (((Boolean)state.method_11654((class_2769)CLOTH)).booleanValue()) {
                    Pair<class_2338, Vector2f> pair = this.getCenterAndOffset((class_1936)level, pos);
                    class_2338 center = (class_2338)pair.getFirst();
                    Vector2f offset = (Vector2f)pair.getSecond();
                    level.method_35230(center, ModBlockEntityTypes.CARD_TABLE).ifPresent(cardTable -> {
                        class_243 c = pos.method_46558();
                        if (!cardTable.centerOffset.equals((Object)offset)) {
                            cardTable.centerOffset = offset;
                            level.method_8413(center, state, state, 3);
                        }
                        if (cardTable.getGame() != null && !cardTable.getGame().isGameOver()) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"message.charta.cant_remove_while_table_occupied").method_27692(class_124.field_1061), true);
                        } else if (!cardTable.getDeckStack().method_7960()) {
                            class_1264.method_5449((class_1937)level, (double)c.field_1352, (double)c.field_1351, (double)c.field_1350, (class_1799)cardTable.getDeckStack());
                            cardTable.setDeckStack(class_1799.field_8037);
                            level.method_8413(center, state, state, 3);
                        } else {
                            class_1767 color = (class_1767)state.method_11654(COLOR);
                            this.getMultiblock((class_1936)level, pos).forEach(p -> {
                                class_2680 s = level.method_8320(p);
                                level.method_8501(p, (class_2680)s.method_11657((class_2769)CLOTH, (Comparable)Boolean.valueOf(false)));
                            });
                            class_1264.method_5449((class_1937)level, (double)c.field_1352, (double)c.field_1351, (double)c.field_1350, (class_1799)DyeColorHelper.getCarpet(color).method_8389().method_7854());
                        }
                    });
                }
            } else {
                class_1799 stack = player.method_6047();
                if (((Boolean)state.method_11654((class_2769)VALID)).booleanValue()) {
                    if (!((Boolean)state.method_11654((class_2769)CLOTH)).booleanValue()) {
                        class_1747 blockItem;
                        class_1792 class_17922 = stack.method_7909();
                        if (class_17922 instanceof class_1747 && (class_17922 = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_5815) {
                            class_5815 carpetBlock = (class_5815)class_17922;
                            if (!player.method_7337()) {
                                stack.method_7934(1);
                            }
                            class_1767 color = carpetBlock.method_33635();
                            this.getMultiblock((class_1936)level, pos).forEach(p -> {
                                class_2680 s = level.method_8320(p);
                                level.method_8501(p, (class_2680)((class_2680)s.method_11657((class_2769)CLOTH, (Comparable)Boolean.valueOf(true))).method_11657(COLOR, (Comparable)color));
                            });
                        } else {
                            player.method_7353((class_2561)class_2561.method_43471((String)"message.charta.put_table_cloth").method_27692(class_124.field_1061), true);
                        }
                    } else if (player instanceof LivingEntityMixed) {
                        LivingEntityMixed mixed = (LivingEntityMixed)player;
                        Pair<class_2338, Vector2f> pair = this.getCenterAndOffset((class_1936)level, pos);
                        class_2338 center = (class_2338)pair.getFirst();
                        Vector2f offset = (Vector2f)pair.getSecond();
                        level.method_35230(center, ModBlockEntityTypes.CARD_TABLE).ifPresent(cardTable -> {
                            if (!cardTable.centerOffset.equals((Object)offset)) {
                                cardTable.centerOffset = offset;
                                level.method_8413(center, state, state, 3);
                            }
                            if (stack.method_7909() instanceof CardDeckItem && stack.method_57826(ModDataComponentTypes.CARD_DECK)) {
                                if (!cardTable.getDeckStack().method_7960()) {
                                    class_243 c = center.method_46558();
                                    class_1264.method_5449((class_1937)level, (double)c.field_1352, (double)c.field_1351, (double)c.field_1350, (class_1799)cardTable.getDeckStack());
                                }
                                cardTable.setDeckStack(stack.method_7972());
                                if (!serverPlayer.method_7337()) {
                                    stack.method_7934(1);
                                }
                                level.method_8413(center, state, state, 3);
                            } else {
                                CardDeck deck = cardTable.getDeck();
                                if (deck != null) {
                                    List<class_1309> satPlayers = cardTable.getPlayers();
                                    if (satPlayers.contains(player)) {
                                        CardGame<?> game = cardTable.getGame();
                                        if (game == null || game.isGameOver()) {
                                            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new TableScreenPayload(center, deck, satPlayers.stream().mapToInt(class_1297::method_5628).toArray()));
                                        } else if (game.getPlayers().contains(mixed.charta_getCardPlayer())) {
                                            game.openScreen(serverPlayer, serverPlayer.method_51469(), center, cardTable.getDeck());
                                        } else {
                                            player.method_7353((class_2561)class_2561.method_43471((String)"message.charta.not_playing_current").method_27692(class_124.field_1061), true);
                                        }
                                    } else {
                                        player.method_7353((class_2561)class_2561.method_43471((String)"message.charta.need_to_be_sat").method_27692(class_124.field_1061), true);
                                    }
                                } else {
                                    player.method_7353((class_2561)class_2561.method_43471((String)"message.charta.table_no_deck").method_27692(class_124.field_1061), true);
                                }
                            }
                        });
                    } else {
                        player.method_7353((class_2561)class_2561.method_43471((String)"message.charta.invalid_card_player").method_27692(class_124.field_1061), true);
                    }
                }
            }
        }
        return class_1269.field_5812;
    }

    protected void method_9536(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean movedByPiston) {
        if (!state.method_27852(newState.method_26204())) {
            if (((Boolean)state.method_11654((class_2769)CLOTH)).booleanValue()) {
                class_243 c = pos.method_46558();
                class_1799 carpetStack = DyeColorHelper.getCarpet((class_1767)state.method_11654(COLOR)).method_8389().method_7854();
                class_1264.method_5449((class_1937)level, (double)c.field_1352, (double)c.field_1351, (double)c.field_1350, (class_1799)carpetStack);
            }
            level.method_35230(pos, ModBlockEntityTypes.CARD_TABLE).ifPresent(entity -> {
                class_243 c = pos.method_46558();
                class_1264.method_5449((class_1937)level, (double)c.field_1352, (double)c.field_1351, (double)c.field_1350, (class_1799)entity.getDeckStack());
                if (entity.getGame() != null && !entity.getGame().isGameOver()) {
                    entity.getGame().endGame();
                }
            });
        }
        super.method_9536(state, level, pos, newState, movedByPiston);
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 state, @NotNull class_2350 direction, @NotNull class_2680 neighborState, @NotNull class_1936 level, @NotNull class_2338 pos, @NotNull class_2338 neighborPos) {
        boolean valid = this.isValidMultiblock(level, pos);
        switch (direction) {
            case field_11043: {
                class_2680 class_26802 = (class_2680)((class_2680)state.method_11657((class_2769)VALID, (Comparable)Boolean.valueOf(valid))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(neighborState.method_27852((class_2248)this)));
                break;
            }
            case field_11034: {
                class_2680 class_26802 = (class_2680)((class_2680)state.method_11657((class_2769)VALID, (Comparable)Boolean.valueOf(valid))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(neighborState.method_27852((class_2248)this)));
                break;
            }
            case field_11035: {
                class_2680 class_26802 = (class_2680)((class_2680)state.method_11657((class_2769)VALID, (Comparable)Boolean.valueOf(valid))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(neighborState.method_27852((class_2248)this)));
                break;
            }
            case field_11039: {
                class_2680 class_26802 = (class_2680)((class_2680)state.method_11657((class_2769)VALID, (Comparable)Boolean.valueOf(valid))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(neighborState.method_27852((class_2248)this)));
                break;
            }
            default: {
                class_2680 class_26802 = state = (class_2680)super.method_9559(state, direction, neighborState, level, pos, neighborPos).method_11657((class_2769)VALID, (Comparable)Boolean.valueOf(valid));
            }
        }
        return neighborState.method_27852((class_2248)this) ? (class_2680)state.method_11657((class_2769)CLOTH, (Comparable)((Boolean)neighborState.method_11654((class_2769)CLOTH))) : (valid ? state : (class_2680)state.method_11657((class_2769)CLOTH, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected class_2680 method_9598(class_2680 state, @NotNull class_2470 rot) {
        boolean north = (Boolean)state.method_11654((class_2769)NORTH);
        boolean east = (Boolean)state.method_11654((class_2769)EAST);
        boolean south = (Boolean)state.method_11654((class_2769)SOUTH);
        boolean west = (Boolean)state.method_11654((class_2769)WEST);
        state = (class_2680)state.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(false));
        state = (class_2680)state.method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(false));
        state = (class_2680)state.method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(false));
        state = (class_2680)state.method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(false));
        if (north) {
            switch (rot.method_10503(class_2350.field_11043)) {
                case field_11043: {
                    state = (class_2680)state.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11034: {
                    state = (class_2680)state.method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11035: {
                    state = (class_2680)state.method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11039: {
                    state = (class_2680)state.method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        if (east) {
            switch (rot.method_10503(class_2350.field_11034)) {
                case field_11043: {
                    state = (class_2680)state.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11034: {
                    state = (class_2680)state.method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11035: {
                    state = (class_2680)state.method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11039: {
                    state = (class_2680)state.method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        if (south) {
            switch (rot.method_10503(class_2350.field_11035)) {
                case field_11043: {
                    state = (class_2680)state.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11034: {
                    state = (class_2680)state.method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11035: {
                    state = (class_2680)state.method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11039: {
                    state = (class_2680)state.method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        if (west) {
            switch (rot.method_10503(class_2350.field_11039)) {
                case field_11043: {
                    state = (class_2680)state.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11034: {
                    state = (class_2680)state.method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11035: {
                    state = (class_2680)state.method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11039: {
                    state = (class_2680)state.method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(true));
                }
            }
        }
        return state;
    }

    @NotNull
    protected class_2680 method_9569(@NotNull class_2680 state, @NotNull class_2415 mirror) {
        if (mirror == class_2415.field_11301) {
            boolean east = (Boolean)state.method_11654((class_2769)EAST);
            boolean west = (Boolean)state.method_11654((class_2769)WEST);
            state = (class_2680)((class_2680)state.method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(west))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(east));
        } else if (mirror == class_2415.field_11300) {
            boolean north = (Boolean)state.method_11654((class_2769)NORTH);
            boolean south = (Boolean)state.method_11654((class_2769)SOUTH);
            state = (class_2680)((class_2680)state.method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(south))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(north));
        }
        return state;
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        boolean valid = this.isValidMultiblock((class_1936)context.method_8045(), context.method_8037());
        return (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)VALID, (Comparable)Boolean.valueOf(valid))).method_11657((class_2769)NORTH, (Comparable)Boolean.valueOf(context.method_8045().method_8320(context.method_8037().method_10095()).method_27852((class_2248)this)))).method_11657((class_2769)EAST, (Comparable)Boolean.valueOf(context.method_8045().method_8320(context.method_8037().method_10078()).method_27852((class_2248)this)))).method_11657((class_2769)SOUTH, (Comparable)Boolean.valueOf(context.method_8045().method_8320(context.method_8037().method_10072()).method_27852((class_2248)this)))).method_11657((class_2769)WEST, (Comparable)Boolean.valueOf(context.method_8045().method_8320(context.method_8037().method_10067()).method_27852((class_2248)this)));
    }

    @NotNull
    protected class_265 method_9530(class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        Combination combination = new Combination((Boolean)state.method_11654((class_2769)VALID), (Boolean)state.method_11654((class_2769)NORTH), (Boolean)state.method_11654((class_2769)EAST), (Boolean)state.method_11654((class_2769)SOUTH), (Boolean)state.method_11654((class_2769)WEST));
        return SHAPES.getOrDefault(combination, class_259.method_1073());
    }

    @NotNull
    protected MapCodec<CardTableBlock> method_53969() {
        return CODEC;
    }

    @NotNull
    protected class_2464 method_9604(@NotNull class_2680 state) {
        return class_2464.field_11458;
    }

    public Set<class_2338> getMultiblock(class_1936 level, class_2338 pos) {
        HashSet<class_2338> multiblock = new HashSet<class_2338>();
        this.floodFill(level, pos, new HashSet<class_2338>(), multiblock);
        return multiblock;
    }

    public Pair<class_2338, Vector2f> getCenterAndOffset(class_1936 level, class_2338 pos) {
        int height;
        Set<class_2338> multiblock = this.getMultiblock(level, pos);
        Vector2f offset = new Vector2f();
        int width = this.getWidth(multiblock);
        if (width % 2 == 0) {
            offset.x = 0.5f;
        }
        if ((height = this.getHeight(multiblock)) % 2 == 0) {
            offset.y = -0.5f;
        }
        class_9380 box = this.getBoundingBox(multiblock);
        class_2338 min = box.comp_2466();
        class_2338 max = box.comp_2467();
        class_2338 center = new class_2338(min.method_10263() + class_3532.method_15357((double)((double)(max.method_10263() - min.method_10263()) / 2.0)), min.method_10264() + class_3532.method_15357((double)((double)(max.method_10264() - min.method_10264()) / 2.0)), min.method_10260() + class_3532.method_15357((double)((double)(max.method_10260() - min.method_10260()) / 2.0)));
        return Pair.of((Object)center, (Object)offset);
    }

    public boolean isValidMultiblock(class_1936 level, class_2338 pos) {
        int height;
        Set<class_2338> multiblock = this.getMultiblock(level, pos);
        int width = this.getWidth(multiblock);
        return this.isValidDimensions(width, height = this.getHeight(multiblock)) && this.isBoundingBoxFilled(level, this.getBoundingBox(multiblock));
    }

    private void floodFill(class_1936 level, class_2338 pos, Set<class_2338> visited, Set<class_2338> multiblock) {
        if (multiblock.size() > MAX_SIZE) {
            return;
        }
        if (!visited.add(pos)) {
            return;
        }
        if (level.method_8320(pos).method_26204() != this) {
            return;
        }
        multiblock.add(pos);
        this.floodFill(level, pos.method_10095(), visited, multiblock);
        this.floodFill(level, pos.method_10072(), visited, multiblock);
        this.floodFill(level, pos.method_10078(), visited, multiblock);
        this.floodFill(level, pos.method_10067(), visited, multiblock);
    }

    private class_9380 getBoundingBox(Set<class_2338> multiblock) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int y = 0;
        for (class_2338 pos : multiblock) {
            minX = Math.min(minX, pos.method_10263());
            maxX = Math.max(maxX, pos.method_10263());
            minZ = Math.min(minZ, pos.method_10260());
            maxZ = Math.max(maxZ, pos.method_10260());
            y = pos.method_10264();
        }
        return class_9380.method_58237((class_2338)new class_2338(minX, y, minZ), (class_2338)new class_2338(maxX, y, maxZ));
    }

    private boolean isBoundingBoxFilled(class_1936 level, class_9380 boundingBox) {
        for (class_2338 pos : boundingBox) {
            if (level.method_8320(pos).method_26204() == this) continue;
            return false;
        }
        return true;
    }

    private boolean isValidDimensions(int width, int height) {
        return VALID_DIMENSIONS.contains(new Vector2i(width, height)) || VALID_DIMENSIONS.contains(new Vector2i(height, width));
    }

    private int getWidth(Set<class_2338> multiblock) {
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (class_2338 pos : multiblock) {
            minX = Math.min(minX, pos.method_10263());
            maxX = Math.max(maxX, pos.method_10263());
        }
        return maxX - minX + 1;
    }

    private int getHeight(Set<class_2338> multiblock) {
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : multiblock) {
            minZ = Math.min(minZ, pos.method_10260());
            maxZ = Math.max(maxZ, pos.method_10260());
        }
        return maxZ - minZ + 1;
    }

    static {
        VALID = class_2746.method_11825((String)"valid");
        NORTH = class_2746.method_11825((String)"north");
        EAST = class_2746.method_11825((String)"east");
        SOUTH = class_2746.method_11825((String)"south");
        WEST = class_2746.method_11825((String)"west");
        CLOTH = class_2746.method_11825((String)"cloth");
        COLOR = class_2754.method_11850((String)"color", class_1767.class);
        Vector2i last = VALID_DIMENSIONS.getLast();
        MAX_SIZE = last.x * last.y;
        for (int i = 0; i < 32; ++i) {
            boolean[] combination = new boolean[5];
            for (int j = 0; j < 5; ++j) {
                combination[j] = (i & 1 << j) != 0;
            }
            boolean valid = combination[0];
            boolean north = combination[1];
            boolean east = combination[2];
            boolean south = combination[3];
            boolean west = combination[4];
            class_265 combinedShape = CENTER;
            if (!north && !east) {
                combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)FEET_NORTH_EAST, (class_247)class_247.field_1366);
            }
            if (!south && !east) {
                combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)FEET_SOUTH_EAST, (class_247)class_247.field_1366);
            }
            if (!south && !west) {
                combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)FEET_SOUTH_WEST, (class_247)class_247.field_1366);
            }
            if (!north && !west) {
                combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)FEET_NORTH_WEST, (class_247)class_247.field_1366);
            }
            if (valid) {
                if (!north && east && south && !west) {
                    combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)CORNER_NORTH_WEST, (class_247)class_247.field_1366);
                }
                if (!north && !east && south && west) {
                    combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)CORNER_NORTH_EAST, (class_247)class_247.field_1366);
                }
                if (north && !east && !south && west) {
                    combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)CORNER_SOUTH_EAST, (class_247)class_247.field_1366);
                }
                if (north && east && !south && !west) {
                    combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)CORNER_SOUTH_WEST, (class_247)class_247.field_1366);
                }
                if (north && east && south && !west) {
                    combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)SIDE_WEST, (class_247)class_247.field_1366);
                }
                if (!north && east && south && west) {
                    combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)SIDE_NORTH, (class_247)class_247.field_1366);
                }
                if (north && !east && south && west) {
                    combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)SIDE_EAST, (class_247)class_247.field_1366);
                }
                if (north && east && !south && west) {
                    combinedShape = class_259.method_1072((class_265)combinedShape, (class_265)SIDE_SOUTH, (class_247)class_247.field_1366);
                }
            }
            SHAPES.put(new Combination(valid, north, east, south, west), combinedShape);
        }
    }

    private record Combination(boolean valid, boolean north, boolean east, boolean south, boolean west) {
    }
}

